/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.io.IOException;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.ConverterFormatter;
import tech.units.indriya.format.SymbolMap;
import tech.units.indriya.unit.AnnotatedUnit;
import tech.units.indriya.unit.BaseUnit;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;

class EBNFHelper {
    static final int ADDITION_PRECEDENCE = 0;
    static final int PRODUCT_PRECEDENCE = 2;
    static final int EXPONENT_PRECEDENCE = 4;
    static final char MIDDLE_DOT = '\u00b7';
    private static final char EXPONENT_1 = '\u00b9';
    private static final char EXPONENT_2 = '\u00b2';
    static final int NOOP_PRECEDENCE = Integer.MAX_VALUE;

    EBNFHelper() {
    }

    static int formatInternal(Unit<?> unit, Appendable buffer, SymbolMap symbolMap) throws IOException {
        String symbol;
        if (unit instanceof AnnotatedUnit) {
            unit = ((AnnotatedUnit)unit).getActualUnit();
        }
        if ((symbol = symbolMap.getSymbol(unit)) != null) {
            return EBNFHelper.noopPrecedenceInternal(buffer, symbol);
        }
        if (unit.getBaseUnits() != null) {
            return EBNFHelper.productPrecedenceInternal(unit, buffer, symbolMap);
        }
        if (unit instanceof BaseUnit) {
            return EBNFHelper.noopPrecedenceInternal(buffer, ((BaseUnit)unit).getSymbol());
        }
        if (unit.getSymbol() != null) {
            return EBNFHelper.noopPrecedenceInternal(buffer, unit.getSymbol());
        }
        UnitConverter converter = null;
        boolean printSeparator = false;
        StringBuilder temp = new StringBuilder();
        int unitPrecedence = Integer.MAX_VALUE;
        Unit<Object> parentUnit = unit.getSystemUnit();
        converter = ((AbstractUnit)unit).getSystemConverter();
        if (Units.KILOGRAM.equals(parentUnit)) {
            if (unit.equals(Units.GRAM)) {
                buffer.append(symbolMap.getSymbol(Units.GRAM));
                return Integer.MAX_VALUE;
            }
            parentUnit = Units.GRAM;
            converter = unit instanceof TransformedUnit ? ((TransformedUnit)unit).getConverter() : unit.getConverterTo(Units.GRAM);
        } else if (Units.CUBIC_METRE.equals(parentUnit) && converter != null) {
            parentUnit = Units.LITRE;
        }
        if (unit instanceof TransformedUnit) {
            TransformedUnit transUnit = (TransformedUnit)unit;
            if (parentUnit == null) {
                parentUnit = transUnit.getSystemUnit();
            }
            converter = transUnit.getConverter();
        }
        unitPrecedence = EBNFHelper.formatInternal(parentUnit, temp, symbolMap);
        printSeparator = !parentUnit.equals(AbstractUnit.ONE);
        int result = ConverterFormatter.formatConverter(converter, printSeparator, unitPrecedence, temp, symbolMap);
        buffer.append(temp);
        return result;
    }

    private static void formatExponent(Unit<?> unit, int pow, int root, boolean continued, Appendable buffer, SymbolMap symbolMap) throws IOException {
        StringBuilder temp;
        int unitPrecedence;
        if (continued) {
            buffer.append('\u00b7');
        }
        if ((unitPrecedence = EBNFHelper.formatInternal(unit, temp = new StringBuilder(), symbolMap)) < 2) {
            temp.insert(0, '(');
            temp.append(')');
        }
        buffer.append(temp);
        if (root != 1 || pow != 1) {
            if (root == 1 && pow > 1) {
                String powStr = Integer.toString(pow);
                block12: for (int i = 0; i < powStr.length(); ++i) {
                    char c = powStr.charAt(i);
                    switch (c) {
                        case '0': {
                            buffer.append('\u2070');
                            continue block12;
                        }
                        case '1': {
                            buffer.append('\u00b9');
                            continue block12;
                        }
                        case '2': {
                            buffer.append('\u00b2');
                            continue block12;
                        }
                        case '3': {
                            buffer.append('\u00b3');
                            continue block12;
                        }
                        case '4': {
                            buffer.append('\u2074');
                            continue block12;
                        }
                        case '5': {
                            buffer.append('\u2075');
                            continue block12;
                        }
                        case '6': {
                            buffer.append('\u2076');
                            continue block12;
                        }
                        case '7': {
                            buffer.append('\u2077');
                            continue block12;
                        }
                        case '8': {
                            buffer.append('\u2078');
                            continue block12;
                        }
                        case '9': {
                            buffer.append('\u2079');
                        }
                    }
                }
            } else if (root == 1) {
                buffer.append('^');
                buffer.append(String.valueOf(pow));
            } else {
                buffer.append("^(");
                buffer.append(String.valueOf(pow));
                buffer.append('/');
                buffer.append(String.valueOf(root));
                buffer.append(')');
            }
        }
    }

    private static int noopPrecedenceInternal(Appendable buffer, String symbol) throws IOException {
        buffer.append(symbol);
        return Integer.MAX_VALUE;
    }

    private static int productPrecedenceInternal(Unit<?> unit, Appendable buffer, SymbolMap symbolMap) throws IOException {
        int pow;
        Map<Unit<?>, Integer> productUnits = unit.getBaseUnits();
        int negativeExponentCount = 0;
        boolean start2 = true;
        for (Map.Entry<Unit<?>, Integer> e : productUnits.entrySet()) {
            pow = e.getValue();
            if (pow >= 0) {
                EBNFHelper.formatExponent(e.getKey(), pow, 1, !start2, buffer, symbolMap);
                start2 = false;
                continue;
            }
            ++negativeExponentCount;
        }
        if (negativeExponentCount > 0) {
            if (start2) {
                buffer.append('1');
            }
            buffer.append('/');
            if (negativeExponentCount > 1) {
                buffer.append('(');
            }
            start2 = true;
            for (Map.Entry<Unit<?>, Integer> e : productUnits.entrySet()) {
                pow = e.getValue();
                if (pow >= 0) continue;
                EBNFHelper.formatExponent(e.getKey(), -pow, 1, !start2, buffer, symbolMap);
                start2 = false;
            }
            if (negativeExponentCount > 1) {
                buffer.append(')');
            }
        }
        return 2;
    }
}

